# 求和练习

Joe 想要得到 orders 表

```sql
create table orders (
    id int primary key auto_increment,
    item_id int,
    amount int,
    unit_price decimal(12, 4),
    total decimal(12, 4),
    description varchar(2000),
    ts timestamp default now(),
    deal bool default false
);
```

中所有单价(unit_price)超过 1000 的订单中，已成交（deal 为 true）的总值（total），这个查询应该是：

<hr/>

点击进入[MySQL实战练习环境](https://mydev.csdn.net/product/pod/new?image=cimg-centos7-skilltreemysql&connect=auto&create=auto&utm_source=skill){target="_blank"}。

* `show databases;` 列出所有数据库
* `show tables;` 列出所有表

## 答案

```sql
select sum(total) 
from orders 
where deal and unit_price > 1000;
```

## 选项

### A

```sql
select sum(total) 
from orders 
having deal and unit_price > 1000;
```

### B

```sql
select sum(total) 
from orders 
group by deal 
having unit_price > 1000;
```

### C

```sql
select sum(total) 
from orders 
order by deal and unit_price > 1000;
```